<?php

return function($site, $pages, $page) {

  $authors = $page->authors()->toPages();

  $similar = $similarPages = $page->similar([
    'index' => $page->siblings(false)->listed(),
    'fields' => [
      'tags' => 1,
      'authors' => 1.5,
      'category' => 3
    ],
    'threshold'      => 0.2,
    'delimiter'      => ',',
    'languageFilter' => false
  ]);

  if ($similar->count() < 4) {
    $fillups = $page->siblings(false)->listed();
    $fillups->shuffle();
    $similar = $similar->merge($fillups);
  }

  $similar = $similar->limit(8);

  if ($page->addPageToCart()) {
    /* If return true, product has been added to cart */
    /* This section only works with noJS and a sucessfull post form */
  }

  $json = [];

  foreach ($similar as $product) {
    $json['data'][$product->id()] = [
      'page' => $product->toArray(),
      'authors' => $product->authors()->toPages()->pluck('title', true),
      'pretty_price' => (string)$product->prettyPrice(),
      'cover' => $product->getCover('shopCoverImage'),
      'category' => [
        'button' => $product->categories()->toPage()->button(),
        'title' => (string)$product->categories()->toPage()->title()
      ],
    ];
  }

  $similar = json_encode($json);


  return compact(
    'authors',
    'similar'
  );
};
