<?php

return [

  'getCover' => function ($srcsetPreset = null) {
    $image = $this->cover();
    if ($image->isNotEmpty()) {
      $image = $image->toFile();
      if ($image && $image->exists()) {

        if ($image->croppedImage()) {
          $image = $image->croppedImage();
        }

        if ($image->alt()->isNotEmpty()) {
          $alt = $image->alt();
        } else {
          $alt = $image->page()->title()->esc();
        }

        return [
          'fileObject' => $image,
          'src' => $image->thumb($srcsetPreset)->url(),
          'srcset' => $image->srcset($srcsetPreset),
          'alt' => $alt,
          'url' => $image->url()
        ];
      }
    }
  },

  'getGallery' => function () {
    $gallery = $this->gallery();
    if ($gallery->isNotEmpty() && $gallery->exists()) {
      $files = $gallery->toFiles();
      if ($files) return $files;
    }
  },

  'buildGallery' => function () {
    $gallery = $this->getGallery();
    if ($gallery) {
      foreach ($gallery as $image) {
        $json;
        $json[$image->id()] = [
          'dimensions' => $image->dimensions(),
          'exif' => $image->exif(),
          'extension' => $image->extension(),
          'filename'=> $image->filename(),
          'hash'=> $image->hash(),
          'isReadable'=> $image->isReadable(),
          'isResizable'=> $image->isResizable(),
          'isWritable'=> $image->isWritable(),
          'mime'=> $image->mime(),
          'modified'=> $image->modified(),
          'name'=> $image->name(),
          'root'=> $image->root(),
          'size'=> $image->size(),
          'type'=> $image->type(),
          'url'=> $image->url(),
          'id'=> $image->id(),
          'template'=> $image->template(),
          'src' => $image->thumb('galleryImage')->url(),
          'srcset' => $image->srcset('galleryImage'),
          'alt' => $image->alt()->value()
        ];
      }
      return json_encode($json);
    }
   },

  'getNumberOfMissingItem' => function ($collection, $goupCount) {
    $remainder = $collection->count() % $goupCount;
    return $goupCount - $remainder;
  }
];
