<?php
namespace Wizhou\Magasin;
use Wizhou\Magasin\Order;

/* A dead simple data class for organisation */

class OrderCustomer extends Order
{
  private $address;
  private $email;
  private $name;
  private $phone;
  private $taxExempt;
  private $taxIds;
  private $prettyAddress;

  public function __construct($data) {
    $this->address = $data->address;
    $this->email = $data->email;
    $this->name = $data->name;
    $this->phone = $data->phone;
    $this->taxExempt = $data->tax_exempt;
    $this->taxIds = $data->tax_ids;
    $this->prettyAddress = Order::prettifyAddress($data->address);
  }

  public function address () {
    return $this->address;
  }

  public function email () {
    return $this->email;
  }

  public function name () {
    return $this->name;
  }

  public function phone () {
    return $this->phone;
  }

  public function taxExempt () {
    return $this->taxExempt;
  }

  public function taxIds () {
    return $this->taxIds;
  }

  public function prettyAddress () {
    return $this->prettyAddress;
  }
}
