<?php
namespace Wizhou\Magasin;
use Wizhou\Magasin\Order;

/* A dead simple data class for organisation */

class OrderShipping
{
  private $name; //String
  private $address; //Stripe\StripeObject
  private $prettyAdress; //String
  private $total; //Number
  private $subtotal; //Number
  private $tax; //Numer
  private $option; //Stripe\ShippingRate

  public function __construct (
    $shipping_cost, //Stripe\StripeObject
    $shipping_details, //Stripe\StripeObject
    $shipping_options, // array of Stripe\StripeObject
  ) {
    $this->name = $shipping_details->name;
    $this->address = $shipping_details->address;
    $this->prettyAddress = Order::prettifyAddress($shipping_details->address);
    $this->total = $shipping_cost->amount_total;
    $this->subtotal = $shipping_cost->amount_subtotal;
    $this->tax = $shipping_cost->amount_tax;

    foreach ($shipping_options as $shipppingOption) {
      if ($shipppingOption->shipping_amount == $this->total) {
        $shippingRate = $shipppingOption->shipping_rate;
        $this->option = \Stripe\ShippingRate::retrieve($shippingRate);
        break;
      }
    }
  }

  public function name () {
    return $this->name;
  }

  public function address () {
    return $this->address;
  }

  public function prettyAddress () {
    return $this->prettyAddress;
  }

  public function total () {
    return $this->total;
  }

  public function subtotal () {
    return $this->subtotal;
  }

  public function tax () {
    return $this->tax;
  }

  public function option () {
    return $this->option;
  }
}
