<?php
return function($site, $pages, $page) {

  if (!get('session_id')) die();
  $sessionId = get('session_id');
  $order = order(csrf(), $sessionId);

  $session = $order->session();
  $line_items = $order->lineItems();
  $customer = $order->customer();
  $shipping = $order->shipping();

  /* Create a collection with all the prodcuts from $line_items
  as Stripe Products. And, create a cart with the  */
  $checkoutCart = new Collection;
  foreach ($line_items->data as $lineItem) {
    $stripeProductId = $lineItem->price->product;

    $stripeProduct = \Stripe\Product::retrieve(
      $stripeProductId,
      []
    );

    $checkoutCart->append($stripeProduct);
    $productUuid = $stripeProduct->metadata->uuid;
    $prodcutPage = $site->page($productUuid);
  }

  $shippingAdress = $shipping->address();
  $prettyCustomerAdress = $customer->prettyAddress();
  $prettyShippingAdress = $shipping->prettyAddress();
  $amountShipping = $order->getShippingTotal();

  $shipppingOptions = $session->shipping_options;
  $shipping_rate = $shipping->option();

  $order->createOrderPage(
    $checkoutCart // Collection with Stripe Product
  );

  $order->sendOrderEmail('order-success');

  /*=============================================>>>>>
  = Flush Cart =
  ===============================================>>>>>*/

  /* Remove the cart session */
  if (cart()->isNotEmpty()) {
    cart()->flushCart();
  }

  return compact(
    'session',
    'customer',
    'line_items',
    'prettyCustomerAdress',
    'shipping',
    'shippingAdress',
    'prettyShippingAdress',
    'shipping_rate',
    'checkoutCart',
  );
};
