<?php

return function ($page, $input) {

  /* When a new order page is created with a checkout session unique ID, update the stock of the order's product(s). */

  $kirby = kirby();
  if ($page->intendedTemplate() == 'order') {

    /* Setup a stripe client to find the products based on the line items. */
    payments()::setStripeApiKey();

    /* Retrive the data stored inside the order page */
    $session = json_decode($page->session()->value());
    $line_items = json_decode($page->line_items()->value());

    foreach ($line_items->data as $product) {

      /* Get the product id for Stripe */
      $stripeProdcutId = $product->price->product;

      /* Retrive the prodcut from stripe */
      $stripeProdcut = \Stripe\Product::retrieve(
        $stripeProdcutId,
        []
      );

      /* Get the page within the site with the uuid */
      $productPage = $kirby->site()->find($stripeProdcut->metadata->uuid);

      /* Calculate the quantity and stock */
      $baseQuantity = $productPage->quantity();
      $orderQuantity = $product->quantity;
      $newQuantity = $baseQuantity - $orderQuantity;

      /* Update the stock */
      $productPage->update([
        'stock' => $newQuantity
      ]);
    }
  }
};
