<?php

use Wizhou\Magasin\Magasin;
use Wizhou\Magasin\Cart;
use Wizhou\Magasin\ProductPage;
use Wizhou\Magasin\Currency;
use Wizhou\Magasin\Order;
use Kirby\Cms\Page;
use Kirby\Exception\Exception;

@include_once __DIR__ . '/vendor/autoload.php';

function magasin (): Magasin {
  return new Magasin();
}

function product () {
  return new ProductPage;
}

function currency () {
  return magasin()->currency();
}

function cart () {
  return magasin()->cart();
}

function shipping () {
  return magasin()->shipping();
}

function payments () {
  return magasin()->payments();
}

function order ($csrf, $sessionId) {
  return magasin()->order($csrf, $sessionId);
}

Kirby::plugin('wizhou/magasin', [
  'options' => [
    'currency' => function () {
      return kirby()->page('shop')->currency()->value();
    },
    'production' => false,
    'stripe' => [
      'test' => [
        'publicKey' => '', // Stripe test public key
        'privateKey' => '' // Stripe test private key
      ],
      'live' => [
        'publicKey' => '', // Stripe live public ke
        'privateKey' => '' // Stripe live private key
      ]
    ],
    // 'stripeWebhooks' => 'whsec_mSQdxaM4x7iBgYvQhkM6E83br7DpBBHY' // Romain Goetz
    'stripeWebhooks' =>  '' // endpoint for customer api
  ],
  'blueprints' => [
    'fields/dimension' => __DIR__ . '/blueprints/fields/dimension.yml',
    'fields/orderCustomer' => __DIR__ . '/blueprints/fields/orderCustomer.yml',
    'fields/orderShipping' => __DIR__ . '/blueprints/fields/orderShipping.yml',
    'fields/price' => __DIR__ . '/blueprints/fields/price.yml',
    'fields/shipping_table_range' => __DIR__ . '/blueprints/fields/shipping_table_range.yml',
    'fields/weight_table' => __DIR__ . '/blueprints/fields/weight_table.yml',

    'pages/shop' => __DIR__ . '/blueprints/pages/shop.yml',
    'pages/checkout' => __DIR__ . '/blueprints/pages/checkout.yml',
    'pages/cart' => __DIR__ . '/blueprints/pages/cart.yml',
    'pages/carrier' => __DIR__ . '/blueprints/pages/carrier.yml',
    'pages/carriers' => __DIR__ . '/blueprints/pages/carriers.yml',
    'pages/product' => __DIR__ . '/blueprints/pages/product.yml',
    'pages/zones' => __DIR__ . '/blueprints/pages/zones.yml',
    'pages/orders' => __DIR__ . '/blueprints/pages/orders.yml',
    'pages/order' => __DIR__ . '/blueprints/pages/order.yml',

    'tabs/quantity' => __DIR__ . '/blueprints/tabs/quantity.yml',
    'tabs/shipping' => __DIR__ . '/blueprints/tabs/shipping.yml',
    'tabs/shop_config' => __DIR__ . '/blueprints/tabs/shop_config.yml'
  ],
  'controllers' => [
    'checkout-success' => include_once __DIR__ . '/controllers/checkout-success.php',
  ],
  'pageModels' => [
    'product' => 'Wizhou\Magasin\ProductPage',
  ],
  'pageMethods' => include_once __DIR__ . '/methods/page.php',
  'routes' => include_once __DIR__ . '/routes/routes.php',
  'hooks' => include_once __DIR__ . '/hooks/hooks.php',
  'templates' => [
    'order' => __DIR__ . '/templates/order.php',
    'emails/order.html' => __DIR__ . '/templates/emails/order.html.php',
  ],
]);


 ?>
