<section
  id="<?= $page->id(); ?>"
  class="posts-item row"
>
  <div class="posts-side posts-images aperture col-6 col-tablet-12">
    <div class="post-gallery">
      <photo-swipe-lightbox
        :slides='<?= $page->getImages()->toJson(); ?>'
        :alts='<?= json_encode($page->getImages()->pluck('alt')); ?>'
        :captions='<?= json_encode($page->getCaptionsToJson($page->getImages())); ?>'
      >
      </photo-swipe-lightbox>
    </div>
  </div>

  <div class="posts-side posts-text aperture col-6 col-tablet-12">
    <span class="date posts-date">
      <?= $page->date()->toDate('d/m/Y'); ?>
    </span>
    <h1 class="posts-title headings headings-unmarged">
      <?= $page->title(); ?>
    </h1>
    <?php foreach ($page->text()->toBlocks() as $block): ?>
      <div
        id="<?= $block->id() ?>"
        class="block block-type-<?= $block->type(); ?>"
      >
        <?= $block ?>
      </div>
    <?php endforeach ?>
    <div class="block-type-tags">
      <?php foreach ($page->tags()->split(',') as $tag): ?>
        <span class="tags"><?= $tag; ?></span>
      <?php endforeach; ?>
    </div>
    <?php snippet('components/button-more', [
      'page' => $page
    ]); ?>
  </div>
</section>
