<section class="project aperture col-10">
  <div class="project-header">
    <h2 class="headings headings-unmarged-bottom canon">
      <?= $page->title(); ?>
    </h2>
    <ul class="list list-inline list-unstyled project-authors">
      <?php foreach ($page->getAuthors() as $author): ?>
        <li class="list-inline-item parangon">
          <a
            href="<?= $author->url(); ?>"
            class="project-link"
          ><?= $author->title(); ?></a>
          <?php if($page->getAuthors()->last() != $author->id()): ?>
          <b>&nbsp;&amp;&nbsp;</b>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>
    <div class="project-infos">
      <?= $page->date()->toDate('d/m/Y'); ?>
      <?php if ($page->categories()->isNotEmpty()): ?>
        <?php $category = $page->categories()->toPage(); ?>
          <a
            class="button button-tag button-clean button-inline-block"
            href="<?= $category->url(); ?>"
          ><?= $category->title(); ?></a>
      <?php endif; ?>
    </div>
  </div>
  <div class="project-main">
    <div class="project-gallery gallery">
      <?php snippet('components/gallery', [
        'page' => $page
      ]); ?>
    </div>
    <div class="project-content">
      <hr>
      <div class="project-text lead">
          <?= $page->text()->toBlocks(); ?>
      </div>
      <div class="project-tags block-type-tags">
        <?php foreach ($page->tags()->split(',') as $tag): ?>
          <span class="tags"><?= $tag; ?></span>
        <?php endforeach; ?>
      </div>
      <div class="project-actions">
        <ul class="project-actions-list list list-inline">
          <?php foreach ($page->callToAction() as $action): ?>
            <li class="project-action list-inline-item">
              <a
                class="button button-<?= $action->theme(); ?>"
                href="<?= $action->link()->toLinkObject(); ?>"
              >
                <?= $action->name(); ?>
              </a>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
  </div>
</section>
