<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="flow authors">
      <?php snippet('components/page-title'); ?>
      <div class="authors-container">
        <ul class="list authors-list list-inline row justify-content-between align-items-baseline">
          <?php foreach ($authors as $author): ?>
            <?php snippet('components/author-item', [
              'author' => $author
            ]); ?>
          <?php endforeach; ?>
          <?php if ($authors->count() % 4 != 0): ?>
            <?php $missing = $page->getNumberOfMissingItem($authors, 4); ?>
            <?php for ($i=0; $i < $missing; $i++): ?>
              <?php snippet('components/author-item-empty') ?>
            <?php endfor; ?>
          <?php endif; ?>
        </ul>
      </div>
      <?php snippet('components/pagination', [
        'pagination' => $pagination
      ]); ?>
  </main>
<?php endslot(); ?>