<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="flow quote">
    <app-quote
      :page="<?= Escape::attr(json_encode($page->toArray())); ?>"
      :papers="<?= Escape::attr(json_encode($papers)); ?>"
      :colors="<?= Escape::attr(json_encode($colors)); ?>"
      :additionals="<?= Escape::attr(json_encode($additionals)); ?>"
    >
      <template #intro>
        <h1>Demande de devis</h1>
        <div class="lead">
          <?= $page->introLead()->kt(); ?>
        </div>
        <?= $page->introText()->kt(); ?>
        <hr/>
      </template>

      <template #paper>
        <div class="quote-section-container quote-paper-container row">
          <div class="col-6 col-tablet-12">
            <div class="A3-paper quote-paper">
              <div class="A3-paper-surface printing-surface">
                <span class="canon">A3</span>
                <span>Surface imprimable<br><?= $page->printing_surface(); ?></span>
              </div>
            </div>
          </div>
          <div class="col-1 hide-tablet" role="prestentaion"></div>
          <div class="col-5 col-tablet-12">
            <div class="quote-paper-details">
              <?= $page->printing_details()->kt(); ?>
            </div>
          </div>
        </div>
      </template>

      <template #paper-details>
        <h3 class="headings headings-unmarged-top">Détail du papier</h3>
        <?= $page->papers_info()->kt(); ?>
      </template>

      <template #paper-select>
        <legend class="col-12">
          <h3 class="headings headings-unmarged-top">Papier souhaité</h3>
          <?= $page->papers_details()->kt(); ?>
        </legend>
      </template>

      <template #color-select>
        <div class="intro col-12">
          <h3 class="headings headings-unmarged-top">Choix des couleurs</h3>
          <?= $page->colors_details()->kt(); ?>
        </div>
      </template>

      <template #graphic-care>
        <div class="intro col-12">
          <h3 class="headings headings-default">
            Prise en charge graphique
          </h3>
          <?= $page->graphic_care()->kt(); ?>
        </div>
      </template>

    </app-quote>
  </main>
<?php endslot(); ?>
