<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="flow ressources">
    <div class="ressources-container row">
      <div class="col-12 aperture">
        <h1><?= $page->title(); ?></h1>
        <div class="headword lead">
          <?= $page->text()->kt(); ?>
        </div>
        <div class="interspace"></div>
      </div>
      <?php foreach ($page->children()->listed() as $child): ?>
        <a
          href="<?= $child->url(); ?>"
          class="col-4 col-tablet-6 col-mobile-12 aperture ressources-card"
        >
          <div class="ressources-card-wrapper">
            <div class="ressources-card-container">
              <div class="ressources-card-header">
              <?php if ($child->cover()->isNotEmpty()): ?>
                <picture>
                  <source
                    srcset="<?= $child->cover()->toFile()->srcset([
                      '500w' => [
                        'width' => 500,
                        'height' => 500,
                        'format' => 'webp',
                        'crop' => true,
                        'quality' => 80
                      ],
                      '350w' => [
                        'width' => 350,
                        'height' => 350,
                        'format' => 'webp',
                        'crop' => true,
                        'quality' => 80
                      ],
                      '200w' => [
                        'width' => 200,
                        'height' => 200,
                        'format' => 'webp',
                        'crop' => true,
                        'quality' => 80
                      ],
                      ]); ?>"
                    type="image/webp"
                  >
                  <img
                    src="<?= $child->cover()->toFile()->thumb([
                      'width' => 500,
                      'height' => 500,
                      'format' => 'jpg',
                      'crop' => true,
                      'quality' => 80
                    ])->url(); ?>"
                  />
                </picture>
                <?php endif; ?>
              </div>
              <div class="ressources-card-body">
                <h3 class="headings headings-unmarged-top"><?= $child->title(); ?></h3>
                <p><?= $child->resume()->kt()->excerpt(160); ?></p>
                <p
                  href="<?= $child->url(); ?>"
                  class="button button-lucid-dreams button-unmarged button-inline-block"
                >
                  En savoir plus
                </p>
              </div>
            </div>
          </div>
        </a>
      <?php endforeach; ?>
    </div>
    <div class="interspace hide-mobile"></div>
  </main>
<?php endslot(); ?>
